const TelegramBot = require('node-telegram-bot-api');
const fs = require('fs');

const TOKEN = "8463700738:AAGxV8pVFx6p0Bx8g0WsEWZb3VKU7rI7hkc";
const OWNER_ID = "7670525689";

const bot = new TelegramBot(TOKEN, { polling: true });

let blocked = JSON.parse(fs.readFileSync('blocked.json', 'utf-8') || '[]');
let stats = JSON.parse(fs.readFileSync('stats.json', 'utf-8') || '{}');
let userDB = JSON.parse(fs.readFileSync('users.json', 'utf-8') || '{}');

const save = (file, data) => fs.writeFileSync(file, JSON.stringify(data, null, 2));

bot.onText(/\/start/, (msg) => {
  const cid = msg.chat.id;
  const isOwner = cid.toString() === OWNER_ID;
  const menu = `
🤖 *Bot Support Telegram*\n\nCara pakai:
• Kirim pesan → akan terkirim ke owner
• Owner reply pesan → balasan dikirim ke Anda\n\n*Menu Perintah:*
/start - Buka menu ini
/info - Info profil user (owner only)
/ceid <username> - Cari ID user (owner only)
/block <id> - Blokir user (owner only)
/unblock <id> - Buka blokir (owner only)
/payment - Info pembayaran
  `;
  bot.sendMessage(cid, menu, { parse_mode: 'Markdown' });
});

bot.on('message', (msg) => {
  const cid = msg.chat.id;
  if (cid.toString() === OWNER_ID) return;
  if (msg.text && msg.text.startsWith('/')) return;
  if (blocked.includes(cid)) return bot.sendMessage(cid, '❌ Anda diblokir.');

  // simpan user
  userDB[cid] = { first_name: msg.from.first_name, username: msg.from.username || null };
  save('users.json', userDB);

  // stats
  const today = new Date().toISOString().slice(0, 10);
  stats[today] = (stats[today] || 0) + 1;
  save('stats.json', stats);

  bot.forwardMessage(OWNER_ID, cid, msg.message_id)
    .then((fwd) => {
      const map = JSON.parse(fs.readFileSync('map.json', 'utf-8') || '{}');
      map[fwd.message_id] = cid;
      save('map.json', map);
    });
});

bot.on('message', (msg) => {
  const cid = msg.chat.id;
  if (cid.toString() !== OWNER_ID) return;
  if (!msg.reply_to_message) return;

  const map = JSON.parse(fs.readFileSync('map.json', 'utf-8') || '{}');
  const uid = map[msg.reply_to_message.message_id];
  if (!uid) return bot.sendMessage(cid, '⚠️ Mapping tidak ditemukan.');

  if (msg.text) bot.sendMessage(uid, msg.text);
});

bot.onText(/\/info/, (msg) => {
  if (msg.chat.id.toString() !== OWNER_ID) return;
  if (!msg.reply_to_message) return bot.sendMessage(OWNER_ID, '⚠️ Reply pesan user.');
  const map = JSON.parse(fs.readFileSync('map.json', 'utf-8') || '{}');
  const uid = map[msg.reply_to_message.message_id];
  if (!uid) return bot.sendMessage(OWNER_ID, '❌ User tidak ditemukan.');
  const u = userDB[uid] || {};
  bot.sendMessage(OWNER_ID, `👤 Info User:\nID: \`${uid}\`\nNama: ${u.first_name}\nUsername: @${u.username || '-'}`,
    { parse_mode: 'Markdown' });
});

bot.onText(/\/ceid (.+)/, (msg, match) => {
  if (msg.chat.id.toString() !== OWNER_ID) return;
  const username = match[1].replace('@', '');
  const entry = Object.entries(userDB).find(([_, v]) => v.username === username);
  if (!entry) return bot.sendMessage(OWNER_ID, '❓ Username tidak ditemukan.');
  const [id, data] = entry;
  bot.sendMessage(OWNER_ID, `🔍 Found:\nID: \`${id}\`\nNama: ${data.first_name}\nUsername: @${data.username}`,
    { parse_mode: 'Markdown' });
});

bot.onText(/\/block (\d+)/, (msg, match) => {
  if (msg.chat.id.toString() !== OWNER_ID) return;
  const id = parseInt(match[1]);
  if (!blocked.includes(id)) blocked.push(id);
  save('blocked.json', blocked);
  bot.sendMessage(OWNER_ID, `🚫 User ${id} diblokir.`);
});

bot.onText(/\/unblock (\d+)/, (msg, match) => {
  if (msg.chat.id.toString() !== OWNER_ID) return;
  const id = parseInt(match[1]);
  blocked = blocked.filter(b => b !== id);
  save('blocked.json', blocked);
  bot.sendMessage(OWNER_ID, `✅ User ${id} dibuka blokirnya.`);
});

bot.onText(/\/payment/, (msg) => {
  const cid = msg.chat.id;
  const text = `💳 *Pembayaran*\n\nPAYMENT: DANA\nNo Rek: 6281226910363\nAtas Nama: Reseller Gaming\n\nMohon kirim bukti transfer ke sini.`;
  const photo = 'qris.jpg'; // taruh file foto di root container
  if (fs.existsSync(photo)) {
    bot.sendPhoto(cid, photo, { caption: text, parse_mode: 'Markdown' });
  } else {
    bot.sendMessage(cid, text, { parse_mode: 'Markdown' });
  }
});

// Statistik harian
setInterval(() => {
  const now = new Date();
  if (now.getHours() === 0 && now.getMinutes() === 0) {
    const today = now.toISOString().slice(0, 10);
    const count = stats[today] || 0;
    bot.sendMessage(OWNER_ID, `📊 Laporan Harian\n📅 ${today}\n💬 Total pesan: ${count}`);
  }
}, 60_000);

console.log("✅ Bot siap dengan semua fitur!");